package gov.va.genisis2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import gov.va.genisis2.common.enums.UserStatusEnum;
import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserApprover;
import gov.va.genisis2.model.UserCount;
import gov.va.genisis2.model.UserRefreshHistory;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.model.WorkflowStatus;
import gov.va.genisis2.vo.CopyTableSource;
import gov.va.genisis2.vo.LdapUser;

/**
 * @author Getaneh Kassahun
 * 
 * 
 */
public class Helper {

	/**
	 * This method is used to getNewRequest.
	 * 
	 * @return this returns new request.
	 * 
	 */
	public static Request getNewRequest() {
		Request request = new Request();
		request.setId(1);
		request.setTitle("Postman Sample Create Request");
		request.setDescription("This is a sample new request for demo purposes");
		request.setRequestTypeId(1);
		request.setSourceId(1);
		request.setStudyApprovalId(176);
		request.setCreatedBy("genisisresearcher1@gmail.com");
		request.setCreatedOn(new Date());
		request.setModifiedBy("genisisresearcher1@gmail.com");
		request.setModifiedOn(new Date());
		// request.setType(1);
		request.setTaskId("taskId");
		request.setProcessId(1);
		request.setApproverId("genisismger1@gmail.com");
		request.setRequestHistories(getNewRequestHistories());
		request.setStatusDescription("StatusDescription");

		return request;
	}

	private static Set<RequestHistory> getNewRequestHistories() {
		Set<RequestHistory> requestHistories = new HashSet<>(Arrays.asList(getNewRequestHistory()));

		return requestHistories;
	}

	public static RequestHistory getNewRequestHistory() {
		RequestHistory requestHistory = new RequestHistory();

		requestHistory.setHistLineNo(1);
		requestHistory.setRequest(new Request());
		requestHistory.setProcessId(1);
		requestHistory.setTitle("Postman Sample Create Request - Updated");
		requestHistory.setDescription("This is a sample new request for demo purposes - updated");
		requestHistory.setStatusDescription("Draft");
		requestHistory.setRequestTypeId(1);
		requestHistory.setSourceId(1);
		requestHistory.setStudyApprovalId(1);
		requestHistory.setCreatedOn(new Date());
		requestHistory.setModifiedOn(new Date());
		requestHistory.setCreatedBy("genisisdatamgr1@gmail.com");
		requestHistory.setModifiedBy("researcher1");
		requestHistory.setApproverId("genisisdatamgr2@gmail.com");
		requestHistory.setTaskId("taskId");

		return requestHistory;
	}

	/**
	 * This method is used to getExistingRequest.
	 * 
	 * @return this returns ExistingRequest.
	 * 
	 */
	public static Request getExistingRequest() {
		Request request = new Request();
		request.setProcessId(999999999);
		request.setId(1);
		request.setTitle("Postman Sample Create Request");
		request.setDescription("This is a sample new request for demo purposes");
		request.setStatusDescription("Return");
		request.setCreatedOn(new Date());
		// request.setType(1);
		request.setCreatedBy("researcher1");
		request.setModifiedBy("researcher1");
		request.setApproverId("datamanager1");
		// request.setComments("Need more information");
		request.setSource(getNewSource());
		request.setRequestType(getNewRequestType());
		request.setStudyApproval(getStudyApproval());

		return request;
	}

	/**
	 * This method is used to getListOfRequest.
	 * 
	 * @return this returns listOfRequest.
	 * 
	 */
	public static List<Request> getListOfRequest() {
		List<Request> listOfRequest = new ArrayList<>();
		Request request = getExistingRequest();
		Request request2 = getExistingRequest();
		request2.setId(2);
		listOfRequest.add(request);
		listOfRequest.add(request2);

		return listOfRequest;
	}

	/**
	 * Source
	 * 
	 * @return Source
	 */
	public static Source getNewSource() {
		Source source = new Source();
		source.setId(1);
		source.setDescription("Survey");
		source.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return source;
	}

	/**
	 * RequestType
	 * 
	 * @return RequestType
	 */
	public static RequestType getNewRequestType() {
		RequestType requestType = new RequestType();
		requestType.setId(1);
		requestType.setDescription("Aggregate");
		requestType.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return requestType;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 */
	public static StudyApproval getNewStudyApproval() {
		StudyApproval studyApproval = new StudyApproval();
		List<Integer> associatedApprovals = new ArrayList<Integer>();

		studyApproval.setProcessId(1);
		associatedApprovals.add(1);
		associatedApprovals.add(2);
		associatedApprovals.add(3);
		// studyApproval.setAssociatedApprovals(associatedApprovals);
		studyApproval.setTitle("Postman sample study approval");
		studyApproval.setDescription("this is a study approval for demo purposes");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setCreatedOn(new Date());
		studyApproval.setModifiedOn(new Date());
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return studyApproval;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static StudyApproval getStudyApproval() {
		StudyApproval studyApproval = new StudyApproval();
		studyApproval.setId(1);
		studyApproval.setProcessId(0);
		studyApproval.setTitle("csp572");
		studyApproval.setDescription("csp572");
		studyApproval.setCreatedOn(new Date());
		studyApproval.setModifiedOn(new Date());
		studyApproval.setProcessId(999999999);
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");

		return studyApproval;
	}

	public static StudyApprovalDTO getStudyApprovalDTO() {
		StudyApprovalDTO studyApproval = new StudyApprovalDTO();
		studyApproval.setId(1);
		studyApproval.setProcessId(0);
		studyApproval.setTitle("csp572");
		studyApproval.setDescription("csp572");
		studyApproval.setCreatedOn(new Date());
		studyApproval.setModifiedOn(new Date());
		studyApproval.setProcessId(999999999);
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");

		return studyApproval;
	}

	/**
	 * User
	 * 
	 * @return User
	 */
	public static User getUser() {
		User user = new User();
		user.setFirstName("Getaneh");
		user.setLastName("Kassa");
		user.setCreateDate(new Date());
		user.setEmailId("genisisad@gmail.com");
		user.setUserActive((byte) 1);
		user.setActiveDate(new Date());
		user.setInactiveDate(null);

		return user;
	}

	/**
	 * User
	 * 
	 * @return User
	 */
	public static User getNewUser() {
		User user = new User();
		user.setUserId(1);
		user.setFirstName("fNmae");
		user.setMiddleName("mName");
		user.setLastName("lName");
		user.setLastName2("lName2");
		user.setCreateDate(new Date());
		user.setEmailId("genisisdatamgr1@gmail.com");
		user.setUserActive((byte) 1);
		user.setActiveDate(new Date());
		user.setInactiveDate(new Date());
		user.setUserApproversForUserId(new HashSet<>(Arrays.asList(new UserApprover())));
		user.setUserRoleTypes(new HashSet<>(Arrays.asList(new UserRoleType())));
		user.setUserApproversForUserApproverId(new HashSet<>(Arrays.asList(new UserApprover())));

		return user;
	}

	public static User getUserLdap() {

		User user = new User();
		user.setFirstName("FirstName");
		user.setLastName("LastName");
		user.setEmailId("EmailId");
		user.setCreateDate(DateUtil.getTodaysDate());
		user.setUserActive((byte) UserStatusEnum.ACTIVE.getId());
		user.setActiveDate(DateUtil.getTodaysDate());
		user.setModifiedOn(DateUtil.getTodaysDate());
		user.setInactiveDate(DateUtil.getTodaysDate());
		user.setUsername("VHAISMICADM");
		return user;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static List<StudyApproval> getListOfStudyApproval() {
		List<StudyApproval> listOfStudyApproval = new ArrayList<StudyApproval>();

		StudyApproval studyApproval1 = new StudyApproval();
		studyApproval1.setId(1);
		studyApproval1.setProcessId(0);
		studyApproval1.setTitle("csp572");
		studyApproval1.setDescription("csp572");
		studyApproval1.setCreatedOn(new Date());
		studyApproval1.setModifiedOn(new Date());
		studyApproval1.setProcessId(999999999);
		studyApproval1.setApprovalIdObtained("approvalIdObtained");
		studyApproval1.setModifiedBy("datamanager1");
		studyApproval1.setCreatedBy("researcher1");

		StudyApproval studyApproval2 = new StudyApproval();
		studyApproval2.setId(2);
		studyApproval2.setProcessId(0);
		studyApproval2.setTitle("csp572");
		studyApproval2.setDescription("csp572");
		studyApproval2.setCreatedOn(new Date());
		studyApproval2.setModifiedOn(new Date());
		studyApproval2.setProcessId(999999999);
		studyApproval2.setApprovalIdObtained("approvalIdObtained");
		studyApproval2.setModifiedBy("datamanager1");
		studyApproval2.setCreatedBy("researcher1");

		listOfStudyApproval.add(studyApproval1);
		listOfStudyApproval.add(studyApproval2);

		return listOfStudyApproval;
	}

	/**
	 * WorkflowStatus
	 * 
	 * @param status
	 * @return WorkflowStatus
	 * 
	 */
	public static WorkflowStatus getWorkFlowStatus(String status) {
		WorkflowStatus workflowStatus = new WorkflowStatus();

		switch (status) {
		case "Draft":
			workflowStatus.setId(1);
			workflowStatus.setDescription("Draft");
			break;
		case "Submitted":
			workflowStatus.setId(2);
			workflowStatus.setDescription("Submitted");
			break;
		case "Denied":
			workflowStatus.setId(3);
			workflowStatus.setDescription("Denied");
			break;
		case "Returned":
			workflowStatus.setId(4);
			workflowStatus.setDescription("Returned");
			workflowStatus.setCommentHistories(new HashSet<>(Arrays.asList(new CommentHistory())));
			break;
		case "Sent":
			workflowStatus.setId(5);
			workflowStatus.setDescription("Sent");
			break;
		case "Update":
			workflowStatus.setId(6);
			workflowStatus.setDescription("Update");
		case "RequestAccepted":
			workflowStatus.setId(7);
			workflowStatus.setDescription("RequestAccepted");
			break;
		case "RequestNotAccepted":
			workflowStatus.setId(8);
			workflowStatus.setDescription("RequestNotAccepted");
			break;
		case "ResultsAccepted":
			workflowStatus.setId(9);
			workflowStatus.setDescription("ResultsAccepted");
			break;
		case "ResultsNotAccepted":
			workflowStatus.setId(10);
			workflowStatus.setDescription("ResultsNotAccepted");
			break;
		case "ResultsDelivered":
			workflowStatus.setId(11);
			workflowStatus.setDescription("ResultsDelivered");
			break;
		default:
			throw new IllegalArgumentException("Invalid Status: " + status);
		}

		return workflowStatus;
	}

	/**
	 * CommentHistory
	 * 
	 * @return CommentHistory
	 */
	public static CommentHistory getCommentHistory() {
		CommentHistory commentHistory = new CommentHistory();
		commentHistory.setRequest(getExistingRequest());
		commentHistory.setWorkflowStatus(getWorkFlowStatus("Returned"));
		commentHistory.setComments("Returned request");
		commentHistory.setCreatedOn(new Date());
		commentHistory.setCreatedBy("datamanger1");
		commentHistory.setRequestId(1);
		commentHistory.setStatus("status");
		commentHistory.setType("type");
		commentHistory.setTaskId("taskId");

		return commentHistory;
	}

	/**
	 * Create test object for UserType
	 * 
	 * @return UserType
	 */
	public static UserType getNewUserType() {
		UserType userType = new UserType();
		userType.setUserTypeId(1);
		userType.setUserTypeDesc("Employee");
		userType.setUserRoleTypes(null);

		return userType;
	}

	/**
	 * Create test object for RoleType
	 * 
	 * @return RoleType
	 */
	public static RoleType getNewRoleType() {
		RoleType roleType = new RoleType();
		roleType.setRoleTypeId(1);
		roleType.setRoleName("Administrator");
		roleType.setRoleDescription("Administrator");
		roleType.setUserRoleTypes(null);

		return roleType;
	}

	/**
	 * Create test object for UserRoleType
	 * 
	 * @return UserRoleType
	 */
	public static UserRoleType getNewUserRoleType() {
		UserRoleType userRoleType = new UserRoleType();
		userRoleType.setId(1);
		userRoleType.setRoleType(getNewRoleType());
		userRoleType.setUser(getUser());
		userRoleType.setUserType(getNewUserType());
		Calendar startDate = Calendar.getInstance();
		startDate.set(2017, 5, 24);
		userRoleType.setStartDate(startDate.getTime());
		userRoleType.setEndDate(startDate.getTime());

		return userRoleType;
	}

	/**
	 * Create test object for LdapUser
	 * 
	 * @return LdapUser
	 */
	public static LdapUser getLdapUser() {

		LdapUser ldapUser = new LdapUser();
		ldapUser.setFirstName("FirstName");
		ldapUser.setLastName("LastName");
		ldapUser.setUsername("Username");
		ldapUser.setEmailId("EmailId");
		ldapUser.setCreateDate(DateUtil.getTodaysDate());
		ldapUser.setUserActive((byte) UserStatusEnum.ACTIVE.getId());
		ldapUser.setActiveDate(DateUtil.getTodaysDate());
		ldapUser.setInactiveDate(DateUtil.getTodaysDate());

		return ldapUser;
	}

	/**
	 * Create test object for UserApprover
	 * 
	 * @return UserApprover
	 */
	public static UserApprover getNewUserApprover() {
		UserApprover userApprover = new UserApprover();
		userApprover.setId(1);
		userApprover.setUsersByUserApproverId(getNewUser());
		userApprover.setUsersByUserId(getNewUser());

		return userApprover;
	}

	public static UserApprover getNewUserApprover1() {
		UserApprover userApprover = new UserApprover();
		userApprover.setId(2);
		userApprover.setUsersByUserApproverId(null);
		userApprover.setUsersByUserId(null);

		return userApprover;
	}

	/**
	 * Create CopyTableSource
	 * 
	 * @return CopyTableSource
	 */
	public static CopyTableSource getCopyTableSource() {
		CopyTableSource copyTableSource = new CopyTableSource("tableNameTest", "tcSourceDataBaseServerNameTest", "tcSourceDataBaseNameTest", "sourceSchemaNameTest", "tcDestinationDataBaseServerNameTest", "tcDestinationDataBaseUserNameTest", "tcDestinationDataBaseUserPasswordTest", "tcDestinationServerDataBaseNameTest", "destinationSchemaNameTest", "tcManagementDataBaseServerNameTest", "tcManagementDataBaseUserNameTest", "tcManagementDataBaseUserPasswordTest", "tcManagementDataBaseSchemaTest", "cmdFilePathTest", "tcManagementDataBaseNameTest", "tcTemporaryDataBaseNameTest");

		return copyTableSource;
	}

	public static UserRoleType getUserRoleType() {

		UserRoleType userRoleType = new UserRoleType();
		userRoleType.setId(1);
		userRoleType.setRoleTypeId(1);
		userRoleType.setUserId(1);
		userRoleType.setUserId(1);
		userRoleType.setStartDate(new Date());
		return userRoleType;
	}

	public static UserRefreshHistory getUserRefreshHistory() {

		UserRefreshHistory userRefreshHistory = new UserRefreshHistory();
		userRefreshHistory.setStartDate(getDate());
		userRefreshHistory.setEndDate(getDate());
		userRefreshHistory.setScheduledBy("NightlyJob");
		userRefreshHistory.setStatus("Started");

		return userRefreshHistory;
	}

	public static UserCount getUserCount() {

		UserCount userCount = new UserCount(1, 2);

		return userCount;
	}

	private static Date getDate() {

		Calendar calendar = Calendar.getInstance();
		// add one day to the date/calendar
		calendar.add(Calendar.DAY_OF_YEAR, 1);
		// now get "tomorrow"
		Date tomorrow = calendar.getTime();
		return tomorrow;
	}
}